/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.plugin.autocrafting.recipebook;

import me.shedaniel.rei.api.client.ClientHelper;
import me.shedaniel.rei.api.client.registry.transfer.TransferHandler;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.display.SimpleGridMenuDisplay;
import me.shedaniel.rei.plugin.common.displays.cooking.DefaultCookingDisplay;
import me.shedaniel.rei.plugin.common.displays.crafting.DefaultCraftingDisplay;
import net.minecraft.client.gui.screens.recipebook.RecipeUpdateListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.CraftingMenu;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.RecipeBookMenu;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class DefaultRecipeBookHandler
implements TransferHandler {
    @Override
    public TransferHandler.Result handle(TransferHandler.Context context) {
        DefaultCookingDisplay defaultDisplay;
        if (context.getDisplay() instanceof SimpleGridMenuDisplay && ClientHelper.getInstance().canUseMovePackets()) {
            return TransferHandler.Result.createNotApplicable();
        }
        Display display = context.getDisplay();
        AbstractContainerMenu abstractContainerMenu = context.getMenu();
        if (!(abstractContainerMenu instanceof RecipeBookMenu)) {
            return TransferHandler.Result.createNotApplicable();
        }
        RecipeBookMenu container = (RecipeBookMenu)abstractContainerMenu;
        if (container == null) {
            return TransferHandler.Result.createNotApplicable();
        }
        if (display instanceof DefaultCraftingDisplay) {
            DefaultCraftingDisplay craftingDisplay = (DefaultCraftingDisplay)display;
            if (craftingDisplay.getOptionalRecipe().isPresent()) {
                int h = -1;
                int w = -1;
                if (container instanceof CraftingMenu) {
                    h = 3;
                    w = 3;
                } else if (container instanceof InventoryMenu) {
                    h = 2;
                    w = 2;
                }
                if (h == -1 || w == -1) {
                    return TransferHandler.Result.createNotApplicable();
                }
                Recipe recipe = (Recipe)craftingDisplay.getOptionalRecipe().get();
                if (craftingDisplay.getHeight() > h || craftingDisplay.getWidth() > w) {
                    return TransferHandler.Result.createFailed((Component)new TranslatableComponent("error.rei.transfer.too_small", new Object[]{h, w}));
                }
                if (!context.getMinecraft().f_91074_.m_108631_().m_12709_(recipe)) {
                    return TransferHandler.Result.createNotApplicable();
                }
                if (!context.isActuallyCrafting()) {
                    return TransferHandler.Result.createSuccessful();
                }
                context.getMinecraft().m_91152_(context.getContainerScreen());
                if (context.getContainerScreen() instanceof RecipeUpdateListener) {
                    ((RecipeUpdateListener)context.getContainerScreen()).m_5564_().f_100269_.m_100140_();
                }
                context.getMinecraft().f_91072_.m_105217_(container.f_38840_, recipe, context.isStackedCrafting());
                return TransferHandler.Result.createSuccessful();
            }
        } else if (display instanceof DefaultCookingDisplay && (defaultDisplay = (DefaultCookingDisplay)display).getOptionalRecipe().isPresent()) {
            Recipe<?> recipe = defaultDisplay.getOptionalRecipe().get();
            if (!context.getMinecraft().f_91074_.m_108631_().m_12709_(recipe)) {
                return TransferHandler.Result.createNotApplicable();
            }
            if (!context.isActuallyCrafting()) {
                return TransferHandler.Result.createSuccessful();
            }
            context.getMinecraft().m_91152_(context.getContainerScreen());
            if (context.getContainerScreen() instanceof RecipeUpdateListener) {
                ((RecipeUpdateListener)context.getContainerScreen()).m_5564_().f_100269_.m_100140_();
            }
            context.getMinecraft().f_91072_.m_105217_(container.f_38840_, recipe, context.isStackedCrafting());
            return TransferHandler.Result.createSuccessful();
        }
        return TransferHandler.Result.createNotApplicable();
    }

    @Override
    public double getPriority() {
        return -20.0;
    }
}

